/*

This file analyzes the data collected through the LINK survey in Feb 2022

Version
8 April 2022 GF - updated after review by GL

*/


* Working directory

cap cd "J:\HEHS\HE\Burden of Covid Restrictions\Swiss Survey\Data\"

* Load final work file

use Covid_restrictions_LINK_sendout_korr.dta, clear

*** Add full labels 

// 24 choice sets 

local i = 1

foreach x of varlist lp801_a01_f801-lp801_a24_f801 {
	label var `x' "Choice set `i'"
	rename `x' choice`i'
	local i = `i'+ 1
}

// Time trade-offs:light restrictions

label var g80210_a01_f "12M normal life vs. 12M light restrictions"
label var g80210_a02_f "10M normal life vs. 12M light restrictions"
label var g80210_a03_f "8M normal life vs. 12M light restrictions"
label var g80210_a04_f "6M normal life vs. 12M light restrictions"
label var g80210_a05_f "4M normal life vs. 12M light restrictions"
label var g80210_a06_f "2M normal life vs. 12M light restrictions"
label var g80210_a07_f "1M normal life vs. 12M light restrictions"
label var g80210_a08_f "0M normal life vs. 12M light restrictions"

// Time trade-offs severe restrictions 

label var g80220_a01_f "12M normal life vs. 12M severe restrictions"
label var g80220_a02_f "10M normal life vs. 12M severe restrictions"
label var g80220_a03_f "8M normal life vs. 12M severe restrictions"
label var g80220_a04_f "6M normal life vs. 12M severe restrictions"
label var g80220_a05_f "4M normal life vs. 12M severe restrictions"
label var g80220_a06_f "2M normal life vs. 12M severe restrictions"
label var g80220_a07_f "1M normal life vs. 12M severe restrictions"
label var g80220_a08_f "0M normal life vs. 12M severe restrictions"


** Code willingness to pay

** Fix small logic error (recode to missing if indifferent in previous question)

replace g80210_a02_f = . if g80210_a01_f > 2
replace g80210_a03_f = . if g80210_a02_f > 2
replace g80210_a04_f = . if g80210_a03_f > 2
replace g80210_a05_f = . if g80210_a04_f > 2
replace g80210_a06_f = . if g80210_a05_f > 2
replace g80210_a07_f = . if g80210_a06_f > 2
replace g80210_a08_f = . if g80210_a07_f > 2

gen wtp_light = .
label var wtp_light "Willingness to pay for light restrictions (range 0-12)"

*Coding rule: top code at 12, bottom code at 0; in between use linear interpolatoin

replace wtp_light = 12 if g80210_a01_f> 1 // top coded at 12 here
replace wtp_light = . if g80210_a01_f> 3 // complete records
replace wtp_light = 11 if g80210_a02_f ==2
replace wtp_light = 10 if g80210_a02_f ==3
replace wtp_light = 9 if g80210_a03_f ==2
replace wtp_light = 8 if g80210_a03_f ==3
replace wtp_light = 7 if g80210_a04_f ==2
replace wtp_light = 6 if g80210_a04_f ==3
replace wtp_light = 5 if g80210_a05_f ==2
replace wtp_light = 4 if g80210_a05_f ==3
replace wtp_light = 3 if g80210_a06_f ==2
replace wtp_light = 2 if g80210_a06_f ==3
replace wtp_light = 1.5 if g80210_a07_f ==2
replace wtp_light = 1 if g80210_a07_f ==3
replace wtp_light = 0.5 if g80210_a08_f ==2
replace wtp_light = 0 if g80210_a08_f ==3
replace wtp_light = 0 if g80210_a08_f ==1 // bottom coding 


** Create utility weight 

gen utility_light =wtp_light/12 
label var utility_light "Utility from life with light restrictions"

** Severe restrictions 

** Fix logic error (recode to missing if indifferent in previous question)

replace g80220_a02_f = . if g80220_a01_f > 2
replace g80220_a03_f = . if g80220_a02_f > 2
replace g80220_a04_f = . if g80220_a03_f > 2
replace g80220_a05_f = . if g80220_a04_f > 2
replace g80220_a06_f = . if g80220_a05_f > 2
replace g80220_a07_f = . if g80220_a06_f > 2
replace g80220_a08_f = . if g80220_a07_f > 2

*Coding rule: top code at 12, bottom code at 0; in between use linear interpolatoin

gen wtp_severe = .
label var wtp_severe "Willingness to pay for severe restrictions (range 0-12)"
replace wtp_severe = 12 if g80220_a01_f> 1 // top coded at 12 here
replace wtp_severe = . if g80220_a01_f> 3 // complete records
replace wtp_severe = 11 if g80220_a02_f ==2
replace wtp_severe = 10 if g80220_a02_f ==3
replace wtp_severe = 9 if g80220_a03_f ==2
replace wtp_severe = 8 if g80220_a03_f ==3
replace wtp_severe = 7 if g80220_a04_f ==2
replace wtp_severe = 6 if g80220_a04_f ==3
replace wtp_severe = 5 if g80220_a05_f ==2
replace wtp_severe = 4 if g80220_a05_f ==3
replace wtp_severe = 3 if g80220_a06_f ==2
replace wtp_severe = 2 if g80220_a06_f ==3
replace wtp_severe = 1.5 if g80220_a07_f ==2
replace wtp_severe = 1 if g80220_a07_f ==3
replace wtp_severe = 0.5 if g80220_a08_f ==2
replace wtp_severe = 0 if g80220_a08_f ==3
replace wtp_severe = 0 if g80220_a08_f ==1

* Compute utility weight 

gen utility_severe =wtp_severe/12 
label var utility_severe "Utility from life with severe restrictions"

** Create restricted variables where almost or never users are excluded 

tab utility_light

gen utility_light_restricted = utility_light 
replace utility_light_restricted =. if wtp_light ==0
replace utility_light_restricted =. if wtp_light ==12
label var utility_light_restricted "Utility weight of light restrictions restricted to expected preference range"

tab utility_severe
gen utility_severe_restricted = utility_severe 
replace utility_severe_restricted =. if wtp_severe ==0
replace utility_severe_restricted =. if wtp_severe ==12
label var utility_severe_restricted "Utility weight of severe restrictions restricted to expected preference range"

// rather extreme preferences here as discussed in paper 

** use this to illustrate extreme preferences in discussion

tab g80220_a08_f

// among those who get last question, large majority prefers zero years (death) to 12 years with restrictions 


*******************************************
* Table 1: Descriptive Statistics
******************************************

gen female = hSex ==2
gen working =  erwerbstaetigkeit==1
tab agegrp, gen(agedum)

tabstat female working agedum*, by(hRegion) stats(sum mean) col(stats)

*********************************************************
* Figure 1: stated WTP for 12 months of restricted life
*********************************************************

hist wtp_severe, discrete xlabel(0 12) graphregion(color(white)) freq ///
ytitle("Frequency") xtitle("Number of months of normal life willing to give for 12 months of restricted life")
tab wtp_severe 



***************************************************************
** Figure 2: average utility weights
*************************************************************** 

*Panel A: unrestricted 

preserve  // temporary collapse of data
statsby _b _se, by(hRegion female) clear: regress utility_severe [aweight=weight]
gen lb = _b-1.96* _se
gen ub = _b+1.96* _se

** for text 
list , clean 

** set up x-axis var

gen group = _n
replace group = group+1 if group > 2 // leave one space between regions
replace group = group+1 if group > 5 // leave one space between regions
replace group = group+1 if group > 8 // leave one space between regions

twoway (bar _b group if female==0) (bar _b group if female==1) (rcap ub lb group), ///
ylabel(0(0.2)1) ytitle("Mean Utility Weight") ///
graphregion(color(white)) legend(order(1 "Male" 2 "Female" 3 "95% CIs")) ///
xlabel(1.5 "German" 4.5 "French" 7.5 "Italian") xtitle("")  graphregion(color(white))
restore 

*Panel B: restricted 

preserve  // temporary collapse of data
statsby _b _se, by(hRegion female) clear: regress utility_severe_restricted [aweight=weight]
gen lb = _b-1.96* _se
gen ub = _b+1.96* _se

** for text 
list , clean 

** set up x-axis var
gen group = _n
replace group = group+1 if group > 2 // leave one space between regions
replace group = group+1 if group > 5 // leave one space between regions
replace group = group+1 if group > 8 // leave one space between regions

twoway (bar _b group if female==0) (bar _b group if female==1) (rcap ub lb group), ///
ylabel(0(0.2)1) ytitle("Mean Utility Weight") ///
graphregion(color(white)) legend(order(1 "Male" 2 "Female" 3 "95% CIs")) ///
xlabel(1.5 "German" 4.5 "French" 7.5 "Italian") xtitle("")  graphregion(color(white))

restore


***************************************************************
** Figure 3: average utility weights by age and gender
*************************************************************** 

*Panel A: unrestricted 

preserve  // temporary collapse of data
statsby _b _se, by(agegrp female) clear: regress utility_severe [aweight=weight]
gen lb = _b-1.96* _se
gen ub = _b+1.96* _se

** for text 
list , clean 

** set up x-axis var

gen group = _n
replace group = group+1 if group > 2 // leave one space between age groups
replace group = group+1 if group > 5 // leave one space between age groups
replace group = group+1 if group > 8 // leave one space between age groups
replace group = group+1 if group > 11 // leave one space between age groups


twoway (bar _b group if female==0) (bar _b group if female==1) (rcap ub lb group), ///
ylabel(0(0.2)1) ytitle("Mean Utility Weight") ///
graphregion(color(white)) legend(order(1 "Male" 2 "Female" 3 "95% CIs")) ///
xlabel(1.5 "18-29" 4.5 "30-44" 7.5 "45-59" 10.5 "60-79") xtitle("")  graphregion(color(white))

restore 

*Panel B: restricted 

preserve  // temporary collapse of data
statsby _b _se, by(agegrp female) clear: regress utility_severe_restricted [aweight=weight]
gen lb = _b-1.96* _se
gen ub = _b+1.96* _se

** for text 
list , clean 

** set up x-axis var

gen group = _n
replace group = group+1 if group > 2 // leave one space between age groups
replace group = group+1 if group > 5 // leave one space between age groups
replace group = group+1 if group > 8 // leave one space between age groups
replace group = group+1 if group > 11 // leave one space between age groups


twoway (bar _b group if female==0) (bar _b group if female==1) (rcap ub lb group), ///
ylabel(0(0.2)1) ytitle("Mean Utility Weight") ///
graphregion(color(white)) legend(order(1 "Male" 2 "Female" 3 "95% CIs")) ///
xlabel(1.5 "18-29" 4.5 "30-44" 7.5 "45-59" 10.5 "60-79") xtitle("")  graphregion(color(white))
restore 

** Averages overall 
regress utility_severe [aweight=weight]
regress utility_severe_restricted [aweight=weight]
 
**********************************
* T2: Willingness to pay 
**********************************

* Step 1: keep key variables and reshape to get one row per vignete  

// gen unique respondent ID
gen ID = _n

// keep key vars 
keep ID choice* sprach weight hRegion female 

reshape long choice, i(ID) j(vignette)
label drop _all
drop if choice ==.
codebook choice 

// check expected number of responses 

di 1299*6
//looks good 

// In order to to difference out option set traits, it is easiest to create two rows for each vignette 
expand 2 

// within each pair, use first row for option A, and second for option B
bysort ID vignette: gen index = _n
gen option = "A"
replace option = "B" if index ==2
drop index 

// create binary selection indicator 
gen selected = 0
replace selected = 1 if option=="A" & choice ==1
replace selected = 1 if option=="B" & choice ==2

** add on vignette information: 

rename vignette set // using LINK variable name (set instead of vignette here)
sort set option
merge m:1 set option using vignettes_15March2022.dta
// clean merge
drop _merge

** Create decision ID to account for data structure (separate record for each decision)

egen decisionID = group(ID set)


** Create normalized as well as salary in k Swiss francs 

gen salary_normed = salary/6500
gen salary_k =salary/1000


// Logistic regression model with decision fixed effects 

** Pooled sample 

clog selected salary_k bars sport masks school travel parties [pweight=weight], group(decisionID) cluster(ID)
outreg2 using t2.xls, replace excel stats(coef ci)

clog selected salary_k bars sport masks school travel parties if hRegion==1 [pweight=weight], group(decisionID) cluster(ID)
outreg2 using t2.xls, append excel stats(coef ci)

clog selected salary_k bars sport masks school travel parties if hRegion==2 [pweight=weight], group(decisionID) cluster(ID)
outreg2 using t2.xls, append excel stats(coef ci)

clog selected salary_k bars sport masks school travel parties if hRegion==3 [pweight=weight], group(decisionID) cluster(ID)
outreg2 using t2.xls, append excel  stats(coef ci)

clog selected salary_k bars sport masks school travel parties if female ==1 [pweight=weight], group(decisionID) cluster(ID)
outreg2 using t2.xls, append excel stats(coef ci)

clog selected salary_k bars sport masks school travel parties if female ==0 [pweight=weight], group(decisionID) cluster(ID)
outreg2 using t2.xls, append excel stats(coef ci)



********************************************
**** Figure 3: willingness to pay 
********************************************

**pooled sample 

clog selected salary_k bars sport masks school travel parties [pweight=weight], group(decisionID) cluster(ID)


*** Create estimated average WTP based on multiple dimensions result

gen graphres = ""
gen meanvalue = .
gen ul = .
gen ll = .

** use non-linar combination of regression coefficients to obain estimated WTP to in 1000 CHF 

local i = 1
foreach x of varlist bars sport masks school travel parties {
    di _b[`x']
	replace graphres = "`x'" in `i'
	nlcom _b[`x']/_b[salary_k]
	replace meanvalue = r(b)[1,1]*-1000 in `i'
	replace ul  = (r(b)[1,1]*-1 +1.96*r(V)[1,1]^0.5)*1000 in  `i'  // coarse approximation here - need to simulate errors here later
	replace ll  = (r(b)[1,1]*-1 -1.96*r(V)[1,1]^0.5) *1000 in  `i'  // coarse approximation here - need to simulate errors here later
		
	local i = `i'+1
}
	
gen gcode = _n if meanvalue!=.

twoway (bar meanvalue gcode) (rcap ul ll gcode), graphregion(color(white)) legend(off) ytitle("Willingness to pay (monthly net ncome in CHF)") xlabel(1 `" "Restaurants"  "and Bars"' 2 "Sports"  3 "Masking" 4 `" "School" "and daycare" "' 5 "Travels"  6 `""Private" "parties""') xtitle("") 




list graphres meanvalue ll ul  if meanval!=.

ddd

*****************************************
* T3 Life years lost and QALYs
*****************************************

* Load most recent data (can download new version to update)

use "Oxford Stringency Index Data 25 March 2022.dta", clear


* restrict to Switzerland

keep if CountryName =="Switzerland"

** create stata dates 

tostring Date, gen(dt)
gen date_stata =date(dt, "YMD")
format date_stata %td
drop dt
order date_stata, after(Date)
label var date_stata "Date"

****************************************************
**  Appendix Figure 2: Stringency index over time
*****************************************************
twoway line StringencyIndex date_stata, graphregion(color(white)) 


** Compute days with high and low 

// restrict to Jan 2020 to Feb 28, 2022

drop if date_stata > date("2022/02/28", "YMD")
gen index_level = int(StringencyIndex/10)
label define index 0 "0-9" 1 "10-19" 2 "20-29" 3 "30-39" 4 "40-49" 5 "50-59" 6 "60-69" 7 "70+"
label values index_level index
tab index 
** compute days here 

*******************************
* Life years lost by canton
*******************************

* Import mortality data from Excel

import excel "COVID19Deaths_age_region_sex.xlsx", sheet("Sheet1") clear first 


* create tables by gender and canton  

gen deaths = 1

preserve
keep if sex=="male"
collapse (sum) deaths, by(geoRegion age)
rename deaths deaths_male 
save deaths_male.dta, replace 
restore 

keep if sex=="female"
collapse (sum) deaths, by(geoRegion age)
rename deaths deaths_female 

merge 1:1 geoR ageR using deaths_male.dta
drop _merge 
erase deaths_male.dta 

fillin geoRegion ageR

 drop _fillin
recode deaths* (.=0)

* create group 

sort geoR ageR 
bys geoR: gen group =_n-1

label data "Covid deaths Switzerland as of March 25 2022"
save covid_deaths_25march22.dta, replace 

** Compute conditional life expectancies 

import excel "RLE_switzerland.xlsx", sheet("RLE") clear first

gen group = int(age/10)
replace group = 8 if group > 8

collapse M F, by(group)
rename M LE_male
rename F LE_female 


** Merge to mortality file 

merge 1:m group using covid_deaths_25march22.dta
drop _merge // looks clean 

** Compute life years lost 

gen YLL_female = LE_female* deaths_female
gen YLL_male = LE_male* deaths_male
gen YLL_total = YLL_male + YLL_female 

*************************************************************************
** Appendix 3: Population size, number of deaths and life years lost 
***********************************************************************

save wf_temp.dta, replace // temporary save to add on population data 

import excel "population_canton_sex_age.xlsx", sheet("POPKT") firstrow clear
collapse (sum) pop, by(KT)
rename KT geoRegion

merge 1:m geoRegion using wf_temp.dta
keep if _merge ==3  //dropping Liechtenstein here 
drop _merge 
erase wf_temp.dta // remove temporary file 


table geoRegion, c(mean pop sum deaths_female sum YLL_female sum deaths_male sum YLL_male)



********************************************
** Table 3: YLLs by canton
********************************************

drop if geoR =="FL"
table geoRegion, c(sum deaths_female sum YLL_female sum deaths_male sum YLL_male)

* QALYs: define utility weights here 

scalar utility_severe =0.39  // estimated above in restricted sample
scalar utility_medium =0.6 // interpolated
scalar utility_light =0.8 // interpolated

* Days of restrictions 

scalar days_severe = 41
scalar days_medium = 392
scalar days_light = 295

* collapse by canton and compute QALYs 

collapse (mean) pop, by(geoRegion)
gen QALYs_severe = days_severe/365*(1-utility_severe)*pop
gen QALYs_medium = days_medium/365*(1-utility_medium)*pop
gen QALYs_light = days_light/365*(1-utility_light)*pop
gen QALYs_total =  QALYs_severe + QALYs_medium+QALYs_light

list, clean 

gen all = 1
table all, c(sum QALYs_severe sum QALYs_medium sum QALYs_light sum QALYs_total)











